#ifndef VECTOR3_TYPE_H
#define VECTOR3_TYPE_H 

#include ".\pythoninclude\Python.h"
#include ".\pythoninclude\structmember.h"

typedef struct {
    PyObject_HEAD
	float ob_xval;
	float ob_yval;
	float ob_zval;
} Vector3Object;

static PyMemberDef Vector3_members[] = {
    {"x", T_FLOAT, offsetof(Vector3Object, ob_xval), 0,
     "Vector3 x-coordinate"},
    {"y", T_FLOAT, offsetof(Vector3Object, ob_yval), 0,
     "Vector3 y-coordinate"},
    {"z", T_FLOAT, offsetof(Vector3Object, ob_zval), 0,
     "Vector3 z-coordinate"},
    {NULL}  /* Sentinel */
};

PyObject* Vector3_new(PyTypeObject *type, PyObject *args, PyObject *kwds);
int Vector3_init(Vector3Object* self, PyObject *args, PyObject *kwds);
void Vector3_dealloc(Vector3Object* self);



static PyTypeObject Vector3ObjectType = {
    PyVarObject_HEAD_INIT(NULL, 0)
    "Vector3",             /* tp_name */
    sizeof(Vector3Object), /* tp_basicsize */
    0,                         /* tp_itemsize */
    (destructor)Vector3_dealloc, /* tp_dealloc */
    0,                         /* tp_print */
    0,                         /* tp_getattr */
    0,                         /* tp_setattr */
    0,                         /* tp_reserved */
    0,                         /* tp_repr */
    0,                         /* tp_as_number */
    0,                         /* tp_as_sequence */
    0,                         /* tp_as_mapping */
    0,                         /* tp_hash  */
    0,                         /* tp_call */
    0,                         /* tp_str */
    0,                         /* tp_getattro */
    0,                         /* tp_setattro */
    0,                         /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,        /* tp_flags */
    "Vector3 objects",           /* tp_doc */
	0,		               /* tp_traverse */
    0,		               /* tp_clear */
    0,		               /* tp_richcompare */
    0,		               /* tp_weaklistoffset */
    0,		               /* tp_iter */
    0,		               /* tp_iternext */
	0,             /* tp_methods */
   Vector3_members,             /* tp_members */
    0,                         /* tp_getset */
    0,                         /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)Vector3_init,      /* tp_init */
    0,                         /* tp_alloc */
    Vector3_new,                 /* tp_new */
};

static PyModuleDef Vector3Objectmodule = {
    PyModuleDef_HEAD_INIT,
    "Vector3",
    "Example module that creates an extension type.",
    -1,
    NULL, NULL, NULL, NULL, NULL
};


#endif